package com.example.sefinsa_app.ui.prestamos.crear;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.net.ParseException;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.Navigation;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.ColaSolicitudes;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputLayout;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PrestamosCrearFragment extends Fragment {

    private PrestamosCrearViewModel mViewModel;

    private TextInputLayout tlFechaGrupo, tlGrupo, tlMonto, tlModalidad, tlPagoSemana, tlTarjeton,
            tlNombreAvalNuevo, tlTelefonoAval, tlDireccionAval, tlRuta, tlPoblacion, tlColocadora,
            tlOtrasReferenciasAval,tlGarantiasAval;
    private AutoCompleteTextView acModalidad;

    private Button btnRegistrarPrestamo, btnSubirFotos;
    private Uri image_uri,uri;
    private final int CODIGO_PERMISOS_CAMARA = 1;

    private int banderaGarantiasAval, banderaComprobantesAval;

    ArrayList<Modalidad> modalidades = new ArrayList<>();
    private ArrayAdapter<Modalidad> modalidadesAdapter;

    private String modalidad_id = "", cliente_id, aval_id, abono, tipo_abono, por_cada;

    private int previousLength;
    private boolean backSpace;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private AvalController avalController;
    private ClienteController clienteController;

    private PrestamoController prestamoController;
    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private String ruta_id = "", poblacion_id = "", colocadora_id = "";
    String lat = "";
    String lgt = "";

    private SharedPreferences sesion;

    private TextView tvFechaGrupoAnt, tvGrupoAnt;

    public static PrestamosCrearFragment newInstance() {
        return new PrestamosCrearFragment();
    }
    private final ColaSolicitudes colaSolicitudes = ColaSolicitudes.getInstance();
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_prestamos_crear, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "PrestamosCrearFragment";

        prestamoController = new PrestamoController(getActivity());

        tlFechaGrupo = view.findViewById(R.id.tlFechaGrupo);
        tlGrupo = view.findViewById(R.id.tlGrupo);
        tlMonto = view.findViewById(R.id.tlMonto);
        tlModalidad = view.findViewById(R.id.tlModalidad);
        tlPagoSemana = view.findViewById(R.id.tlPagoSemana);
        tlTarjeton = view.findViewById(R.id.tlTarjeton);

        tlTelefonoAval = view.findViewById(R.id.tlTelefonoAval);
        tlDireccionAval = view.findViewById(R.id.tlDireccionAval);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);
        tlColocadora = view.findViewById(R.id.tlColocadora);
        tlOtrasReferenciasAval = view.findViewById(R.id.tlOtrasReferenciasAval);
        tlGarantiasAval = view.findViewById(R.id.tlGarantiasAval);

        tvFechaGrupoAnt = view.findViewById(R.id.tvFechaGrupoAnt);
        tvGrupoAnt = view.findViewById(R.id.tvGrupoAnt);

        acModalidad = view.findViewById(R.id.acModalidad);

        btnRegistrarPrestamo = view.findViewById(R.id.btnRegistrarPrestamo);
        btnSubirFotos = view.findViewById(R.id.btnSubirFotos);

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);

        Bundle args = getArguments();
        String personJsonString = args.getString("cliente");
        Cliente cliente = Utils.getGsonParser().fromJson(personJsonString, Cliente.class);
        // Mostrar los datos del cliente en el log
        if (cliente != null) {
            Log.d("DEBUG", "Datos del cliente: " + Utils.getGsonParser().toJson(cliente));
        } else {
            Log.d("DEBUG", "El objeto Cliente es nulo. Verifica la cadena JSON de entrada.");
        }
        String fecha = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date());

        aval_id = cliente.getAval_id();
        cliente_id = cliente.getId();

        Log.d("Success", "Cliente con aval en cliente tomado con id: " + aval_id);
        Log.d("Success", "CLiente tomado con id: " + cliente_id);

        getGrupoPoblacion(cliente.getPoblacion_cliente());

        tvFechaGrupoAnt.setText("Fecha grupo ant. : "+ cliente.getFecha_prestamo());
        tvGrupoAnt.setText("Grupo ant. : " + cliente.getGrupo_anterior());

        tlFechaGrupo.getEditText().setText(fecha);

        getSemanasPendientes(cliente_id);

        /*
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();

        modalidades = new ArrayList<Modalidad>();

        getModalidades();

        acModalidad.setOnItemClickListener((adapterView, view1, i, l) -> {
            Modalidad modalidad = modalidadesAdapter.getItem(i);

            tlMonto.getEditText().getText().clear();
            tlPagoSemana.getEditText().getText().clear();
            tlMonto.setError(null);

            modalidad_id = modalidad.getId();

            abono = modalidad.getCantidad_abono();
            tipo_abono = modalidad.getTipo_cantidad();
            if(modalidad.getPor_cada() != null){
                por_cada = modalidad.getPor_cada();
            }
            else{
                por_cada = "";
            }

        });

        acModalidad.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !modalidad_id.equals("")) {
                    acModalidad.setText("");
                    modalidad_id = "";
                    tlMonto.getEditText().getText().clear();
                    tlPagoSemana.getEditText().getText().clear();
                }

            }
        });

        tlMonto.getEditText().addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {

                if(!modalidad_id.equals("")){
                    tlMonto.setError(null);
                    if(editable.toString().length() > 0 ){
                        if(tipo_abono.equals("%")){
                            int pago_semana = (Integer.parseInt(editable.toString()) * Integer.parseInt(abono)) / 100;
                            tlPagoSemana.getEditText().setText(String.valueOf(pago_semana));
                        }
                        else if(tipo_abono.equals("$")){
                            int pago_semana = Integer.parseInt(abono) * (Integer.parseInt(editable.toString()) / Integer.parseInt(por_cada));
                            tlPagoSemana.getEditText().setText(String.valueOf(pago_semana));
                        }
                    }
                }
                else{
                    tlMonto.getEditText().getText().clear();
                    tlMonto.setError("Ingresa una modalidad");
                }



            }
        });

        tlFechaGrupo.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha inicio de grupo");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(getFragmentManager(), "MATERIAL_DATE_PICKER");
                materialDatePicker.addOnPositiveButtonClickListener(
                    new MaterialPickerOnPositiveButtonClickListener() {

                        @SuppressLint("SetTextI18n")
                        @Override
                        public void onPositiveButtonClick(Object selection) {

                            TimeZone timeZoneUTC = TimeZone.getDefault();
                            int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                            Date date = new Date((Long) selection + offsetFromUTC);

                            tlFechaGrupo.getEditText().setText(simpleFormat.format(date));
                        }
                    });
            }
        });

        btnRegistrarPrestamo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(Validator.fieldValidation(tlFechaGrupo, "Ingresa una fecha")
                        && Validator.fieldValidation(tlGrupo, "Ingresa un grupo")
                        && Validator.fieldValidation(tlMonto, "Ingresa una monto")
                        && Validator.fieldValidation(tlModalidad, "Ingresa una modalidad")
                        && Validator.fieldValidation(tlPagoSemana, "Ingresa un pago por semana")
                        && Validator.fieldValidation(tlTarjeton, "Ingresa un tarjetón")
                ){
                    // crearPrestamo(cliente_id);
                    crearPrestamo(cliente_id, aval_id,
                            tlMonto.getEditText().getText().toString(), tlPagoSemana.getEditText().getText().toString(),
                            tlFechaGrupo.getEditText().getText().toString(), modalidad_id,
                            "0",tlTarjeton.getEditText().getText().toString(),
                            tlGrupo.getEditText().getText().toString(), tlFechaGrupo.getEditText().getText().toString()
                    );

                }
            }
        });
    }

    private void getModalidades()
    {

        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");
        modalidad15.setInteres("40");
        modalidad15.setSemana_renovacion("10");
        modalidad15.setCantidad_abono("10");
        modalidad15.setTipo_cantidad("%");
        modalidad15.setDe("Monto prestado");
        modalidad15.setAbono_descripcion("10% de Monto prestado");

        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        modalidad20.setInteres("55");
        modalidad20.setSemana_renovacion("15");
        modalidad20.setCantidad_abono("80");
        modalidad20.setTipo_cantidad("$");
        modalidad20.setPor_cada("1000");
        modalidad20.setAbono_descripcion("$80 por cada $1000");

        modalidades.add(modalidad15);
        modalidades.add(modalidad20);

        modalidadesAdapter = new ArrayAdapter<Modalidad>(getContext(), android.R.layout.simple_dropdown_item_1line, modalidades);
        acModalidad.setThreshold(1);
        acModalidad.setAdapter(modalidadesAdapter);

    }

    private void crearPrestamo(String cliente_id, String aval_id, String monto_prestado, String pago_semanal, String fecha_prestamo, String modalidad,
                               String monto_prestado_intereses, String tarjeton, String grupo, String fecha_inicio_grupo) {

        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

            // Si no hay cliente seleccionado, crear el préstamo directamente con el aval_id proporcionado
            registrarPrestamo(cliente_id, aval_id, monto_prestado, pago_semanal,
                    fecha_prestamo, modalidad, monto_prestado_intereses,
                    tarjeton, grupo, fecha_inicio_grupo, dialog);

    }

    /**
     * Función auxiliar para registrar el préstamo usando el aval_id proporcionado o recién creado.
     */
    private void registrarPrestamo(String cliente_id, String aval_id, String monto_prestado, String pago_semanal,
                                   String fecha_prestamo, String modalidad, String monto_prestado_intereses,
                                   String tarjeton, String grupo, String fecha_inicio_grupo, ProgressDialog dialog) {

        JSONObject dataPrestamo = new JSONObject();
        try {
            dataPrestamo.put("func", "create");
            dataPrestamo.put("cliente_id", cliente_id);
            dataPrestamo.put("aval_id", aval_id);
            dataPrestamo.put("monto_prestado", monto_prestado);
            dataPrestamo.put("pago_semanal", pago_semanal);
            dataPrestamo.put("fecha_prestamo", fecha_prestamo);
            dataPrestamo.put("modalidad", modalidad);
            dataPrestamo.put("tarjeton", tarjeton);
            dataPrestamo.put("grupo", grupo);
            dataPrestamo.put("fecha_inicio_grupo", fecha_inicio_grupo);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest requestPrestamo = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, dataPrestamo,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String prestamoID = response.getJSONObject("data").getString("prestamo_id");
                                Log.d("IDprestamo", "ID del servidor del prestamo.............." + prestamoID);
                                Toast.makeText(getActivity(), "Se ha registrado el préstamo", Toast.LENGTH_LONG).show();
                                guardarPrestamoSQLite(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad, monto_prestado_intereses,
                                        tarjeton, grupo, fecha_inicio_grupo, "on", prestamoID);
                                dialog.dismiss();
                                Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                                        .navigate(R.id.nav_clientes);
                            }
                        } catch (JSONException e) {
                            dialog.dismiss();
                            e.printStackTrace();
                            Toast.makeText(getActivity(), "Error al procesar datos del servidor", Toast.LENGTH_LONG).show();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.dismiss();

                //guardarPrestamoSQLite(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad,monto_prestado_intereses, tarjeton, grupo, fecha_inicio_grupo);
                if (ErrorChecker.checker(error, getActivity()) == 1 || ErrorChecker.checker(error, getActivity()) == 4) {
                    guardarPrestamoSQLite(cliente_id, aval_id, monto_prestado, pago_semanal, fecha_prestamo, modalidad, monto_prestado_intereses,
                            tarjeton, grupo, fecha_inicio_grupo, "off", "");
                    Toast.makeText(getActivity(), "Error al registrar el préstamo, Se Guardo en local", Toast.LENGTH_LONG).show();
                    Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard)
                            .navigate(R.id.nav_clientes);
                }
            }
        });

        requestPrestamo.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        requestPrestamo.setShouldCache(false);
        requestQueue.add(requestPrestamo);
    }

    public void guardarPrestamoSQLite(String cliente_id, String aval_id, String monto_prestado, String pago_semanal,
                                      String fecha_prestamo, String modalidad, String monto_prestado_intereses,
                                      String tarjeton, String grupo, String fecha_inicio_grupo, String online, String prestamoID) {

        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase(); // Asegúrate de tener una instancia de tu DbHelper

        ContentValues values = new ContentValues();

        if(!prestamoID.isEmpty())
        {
            values.put("id", prestamoID);
        }
        values.put("cliente_id", cliente_id);
        values.put("aval_id", aval_id);
        values.put("monto_prestado", monto_prestado);
        values.put("pago_semanal", pago_semanal);
        values.put("fecha_prestamo", fecha_prestamo);
        values.put("modalidad_semanas", modalidad);
        values.put("numero_tarjeton", tarjeton);
        values.put("grupo_poblacion", grupo);
        long timestamp = System.currentTimeMillis();
        // Convertir a objeto Date
        Date date = new Date(timestamp);
        // Formatear la fecha a un formato legible
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(date);
        // Almacenar la fecha formateada como texto
        values.put("updated_at", formattedDate); // Ahora se almacena como texto

        if(online.equals("off")) {
            values.put("status", 8);
        }
        else
        {
            values.put("status", 0);
        }

        // Inserta en la tabla de préstamos y obtiene el ID del préstamo recién insertado
        long result = db.insert("prestamos", null, values); // "prestamos" es el nombre de tu tabla

        if (result == -1) {
            Log.e("Error", "No se pudo insertar el préstamo en la base de datos");
        } else {
            // Aquí obtenemos el último ID insertado en la tabla de préstamos
            long prestamo_id = result; // El ID generado automáticamente del préstamo insertado

            //Log.d("Success", "Préstamo insertado correctamente en SQLite, ID: " + prestamo_id);

            if(online.equals("off"))
            {
                guardarPagosSQLite(String.valueOf(prestamo_id), pago_semanal, fecha_prestamo, Integer.parseInt(modalidad));
            }
            // Llama a la función para guardar los pagos, pasando el ID del préstamo recién insertado
        }

        db.close();
    }

    @SuppressLint("DefaultLocale")
    public void guardarPagosSQLite(String prestamo_id, String monto_semanal, String fecha_prestamo, int modalidadId) {
        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Obtener modalidadCantidad desde la tabla `configuracion_semanas`
        int modalidadCantidad = obtenerCantidadSemanas(db, modalidadId);
        if (modalidadCantidad <= 0) {
            Log.e("Error", "Modalidad no válida o no se encontraron semanas para la modalidad con ID: " + modalidadId);
            db.close();
            return;
        }

        // Formatear monto_semanal a 2 decimales
        double montoSemanalFormateado = Utils.convertirDouble(monto_semanal);
        String montoSemanalCon2Decimales = String.format("%.2f", montoSemanalFormateado);

        // Calcula el balance total y formatea a 2 decimales
        double balance = montoSemanalFormateado * modalidadCantidad;
        String balanceFormateado = String.format("%.2f", balance); // Formatear balance a 2 decimales
        String fechaHoraActual = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date());
        Log.d("FechaHoraActual", "Fecha y hora actual: " + fechaHoraActual);  // Log para verificar la hora actual
        // Construcción del SQL para insertar los pagos
        StringBuilder insertQuery = new StringBuilder();
        insertQuery.append("INSERT INTO pagos (prestamo_id, cantidad_esperada_pago, cantidad_normal_pagada, ")
                .append("cantidad_multa, cantidad_pendiente, cantidad_total_pagada, fecha_pago, semana, balance, status, updated_at) VALUES ");

        for (int i = 1; i <= modalidadCantidad; i++) {
            // Calcula la fecha de pago para cada semana
            String fecha_pago = calcularFechaPago(fecha_prestamo, i);

            // Log detallado de cada pago antes de la inserción con 2 decimales
            Log.d("Insertando Pago", String.format("Prestamo ID: %s, Cantidad Esperada: %.2f, Normal Pagada: %.2f, Multa: %.2f, Total Pagada: %.2f, Fecha Pago: %s, Semana: %d, Balance: %.2f, Status: %d",
                    prestamo_id, montoSemanalFormateado, 0.00, 0.00, 0.00, fecha_pago, i, balance, 0));

            // Agrega la inserción a la consulta SQL, asegurando que las cantidades tengan 2 decimales
            if (i > 1) {
                insertQuery.append(", ");
            }

            // Aquí agregamos el valor de `CURRENT_TIMESTAMP` para los campos `created_at` y `updated_at`
            insertQuery.append(String.format("('%s', '%.2f', '%.2f', '%.2f', '%.2f', '%.2f', '%s', %d, '%.2f', 0, '%s')",
                    prestamo_id, montoSemanalFormateado, 0.00, 0.00, 0.00, 0.00, fecha_pago, i, balance, fechaHoraActual));
        }

        // Ejecuta la inserción de todos los pagos
        try {
            db.execSQL(insertQuery.toString());
            Log.d("Success", "Pagos insertados correctamente en SQLite");
        } catch (Exception e) {
            Log.e("Error", "No se pudo insertar los pagos en la base de datos", e);
        } finally {
            db.close();
        }
    }

    // Método para obtener la cantidad de semanas desde la tabla `configuracion_semanas`
    @SuppressLint("Range")
    private int obtenerCantidadSemanas(SQLiteDatabase db, int modalidadId) {
        int cantidad = 0;
        Cursor cursor = null;

        try {
            cursor = db.rawQuery("SELECT cantidad FROM configuracion_semanas WHERE id = ?", new String[]{String.valueOf(modalidadId)});
            if (cursor != null && cursor.moveToFirst()) {
                cantidad = cursor.getInt(cursor.getColumnIndex("cantidad"));
            } else {
                Log.e("Error", "No se encontró la modalidad con ID: " + modalidadId);
            }
        } catch (Exception e) {
            Log.e("Error", "Error al obtener la cantidad de semanas de configuracion_semanas", e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return cantidad;
    }

    // Función para calcular la fecha de pago (esto lo puedes ajustar según el formato y la lógica que necesitas)
    private String calcularFechaPago(String fechaInicio, int semana) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            Date fechaInicioDate = sdf.parse(fechaInicio);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fechaInicioDate);
            // Agregar una semana para que la primera fecha de pago sea la semana siguiente
            calendar.add(Calendar.WEEK_OF_YEAR, 1);

            // Sumar semanas adicionales según el parámetro "semana"
            calendar.add(Calendar.WEEK_OF_YEAR, semana - 1);

            return sdf.format(calendar.getTime()); // Devolver la fecha en el formato necesario
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        } catch (java.text.ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private void getSemanasPendientes(String cliente_id) {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        SQLiteDatabase db = new DatabaseHelper(getContext()).getReadableDatabase();

        // Consulta SQL
        String query = "SELECT prestamos.numero_tarjeton, prestamos.id as prestamo_id, " +
                "(prestamos.pago_semanal * cs.cantidad) as balance_original, " +
                "((prestamos.pago_semanal * cs.cantidad) - SUM(pagos.cantidad_normal_pagada)) as balance, " +
                "COUNT( CASE WHEN pagos.status = 0 THEN pagos.id END ) semanas_pendientes, " +
                "COUNT( CASE WHEN pagos.status = -1 and pagos.folio is null THEN pagos.id END ) semanas_punto, " +
                "COUNT( CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) semanas_folio " +
                "FROM clientes " +
                "INNER JOIN prestamos on prestamos.cliente_id = clientes.id " +
                "INNER JOIN configuracion_semanas as cs on cs.id = prestamos.modalidad_semanas " +
                "INNER JOIN pagos on pagos.prestamo_id = prestamos.id " +
                "WHERE clientes.id = ? " +
                "AND prestamos.status = 0 " +
                "GROUP BY prestamos.numero_tarjeton " +
                "ORDER BY prestamos.id DESC";

        Cursor cursor = db.rawQuery(query, new String[]{cliente_id});

        if (cursor != null && cursor.moveToFirst()) {
            try {
                @SuppressLint("Range") String tarjeton = cursor.getString(cursor.getColumnIndex("numero_tarjeton"));
                @SuppressLint("Range") String prestamo_id = cursor.getString(cursor.getColumnIndex("prestamo_id"));
                @SuppressLint("Range") double balance = cursor.getDouble(cursor.getColumnIndex("balance"));
                @SuppressLint("Range") int semanasPendientes = cursor.getInt(cursor.getColumnIndex("semanas_pendientes"));
                @SuppressLint("Range") int semanasPunto = cursor.getInt(cursor.getColumnIndex("semanas_punto"));
                @SuppressLint("Range") int semanasFolio = cursor.getInt(cursor.getColumnIndex("semanas_folio"));

                // Mostrar los datos obtenidos
                Log.d("SemanasPendientes", "Tarjeton: " + tarjeton + ", Prestamo ID: " + prestamo_id);
                Log.d("SemanasPendientes", "Balance: " + balance + ", Semanas Pendientes: " + semanasPendientes);

                // Mostrar el mensaje con los datos obtenidos
                if (semanasPendientes > 0) {
                    String mensaje = "Este cliente tiene un préstamo (" + tarjeton + ") con:\n " +
                            semanasPendientes + " semanas pendientes,\n " +
                            semanasPunto + " semanas con punto,\n " +
                            semanasFolio + " semanas con folio " + "y un\n " +
                            "monto de $" + balance +
                            ", \n\nAntes de continuar verifica las semanas pendientes o comunícate con tu administrador,\n\n ¿Quieres renovarlo?";

                    // Crear un SpannableString a partir del mensaje
                    SpannableString spannableMessage = new SpannableString(mensaje);

                    // Resaltar partes del mensaje (como en tu código original)
                    String textoResaltar = "Antes de continura verifica las semanas pendientes o comunícate con tu administrador";
                    int start = mensaje.indexOf(textoResaltar);
                    int end = start + textoResaltar.length();
                    if (start >= 0) {
                        spannableMessage.setSpan(new ForegroundColorSpan(Color.RED), start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                        spannableMessage.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    }

                    // Aplicar negritas a cada uno de los valores específicos
                    int startMonto = mensaje.indexOf("monto de $" + balance);
                    if (startMonto >= 0) {
                        spannableMessage.setSpan(new StyleSpan(Typeface.BOLD), startMonto, startMonto + ("monto de $" + balance).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    }
                    int startPunto = mensaje.indexOf(semanasPunto + " semanas con punto");
                    if (startPunto >= 0) {
                        spannableMessage.setSpan(new StyleSpan(Typeface.BOLD), startPunto, startPunto + String.valueOf(semanasPunto).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    }
                    int startFolio = mensaje.indexOf(semanasFolio + " semanas con folio");
                    if (startFolio >= 0) {
                        spannableMessage.setSpan(new StyleSpan(Typeface.BOLD), startFolio, startFolio + String.valueOf(semanasFolio).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    }
                    int startPendientes = mensaje.indexOf(semanasPendientes + " semanas pendientes");
                    if (startPendientes >= 0) {
                        spannableMessage.setSpan(new StyleSpan(Typeface.BOLD), startPendientes, startPendientes + String.valueOf(semanasPendientes).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    }

                    new MaterialAlertDialogBuilder(getActivity())
                            .setCancelable(false)
                            .setTitle("Pagar pendientes")
                            .setMessage(spannableMessage)  // Establecer el mensaje con el texto estilizado
                            .setPositiveButton("SÍ", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                    pagarSemanasPendientes(prestamo_id);
                                }
                            })
                            .setNegativeButton("NO", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {
                                }
                            })
                            .show();
                } else {
                    Toast.makeText(getActivity(), "Este cliente no tiene préstamos anteriores", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {
                Log.e("SQLiteError", "Error al procesar los datos de la base de datos local", e);
            } finally {
                cursor.close();
            }
        } else {
            Log.d("RESPONSE", "El cliente no tiene datos pendientes en la base de datos.");
            Toast.makeText(getActivity(), "No se encontraron datos de préstamos pendientes.", Toast.LENGTH_SHORT).show();
        }

        dialog.cancel();
    }


    private void pagarSemanasPendientes(String prestamo_id) {
        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "pagarSemanasPendientes");
            data.put("prestamo_id", prestamo_id);
            data.put("empleado_id", sesion.getString("id", "0"));

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        // Mostrar el mensaje de éxito
                        Toast.makeText(getActivity(), "Se ha realizado la renovación del préstamo", Toast.LENGTH_LONG).show();
                        actualizarPrestamoYSemanas(prestamo_id);
                    }
                },
                new Response.ErrorListener() {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        ErrorChecker.checker(error, getActivity());
                        actualizarPrestamoYSemanas(prestamo_id);
                    }
                });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    @SuppressLint("Range")
    private void actualizarPrestamoYSemanas(String prestamo_id) {
        // Crear instancia de la base de datos
        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Obtener el valor de 'pago_semanal' desde la tabla 'prestamos'
        Cursor cursor = db.query("prestamos", new String[]{"pago_semanal"}, "id = ?", new String[]{prestamo_id}, null, null, null);

        String pagoSemanal = "";
        if (cursor != null && cursor.moveToFirst()) {
            // Si encontramos el préstamo, obtenemos el pago_semanal
            pagoSemanal = cursor.getString(cursor.getColumnIndex("pago_semanal"));
            cursor.close();
        } else {
            Log.d("SQLite", "No se encontró el préstamo con prestamo_id: " + prestamo_id);
            return;  // Si no se encuentra el préstamo, no continuamos
        }

        // Actualizar el status del préstamo a 2
        ContentValues valoresPrestamo = new ContentValues();
        valoresPrestamo.put("status", 2);
        int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{prestamo_id});

        if (updatePrestamoResult > 0) {
            Log.d("SQLite", "Status del préstamo actualizado a 2 para prestamo_id: " + prestamo_id);

            // Marcar todas las semanas restantes como pagadas en la tabla de pagos y actualizar campos
            ContentValues valoresPagos = new ContentValues();
            valoresPagos.put("cantidad_normal_pagada", pagoSemanal);
            valoresPagos.put("cantidad_total_pagada", pagoSemanal);
            valoresPagos.put("cantidad_pendiente", "0.00");
            valoresPagos.put("balance", "0");
            valoresPagos.put("status", "1"); // 1 representa semanas pagadas
            valoresPagos.put("empleado_id", sesion.getString("id", "0"));

            int updatePagosResult = db.update("pagos", valoresPagos, "prestamo_id = ? AND status = 0", new String[]{prestamo_id});

            if (updatePagosResult > 0) {
                Log.d("SQLite", "Semanas pendientes actualizadas a pagadas para prestamo_id: " + prestamo_id);
            } else {
                Log.d("SQLite", "No se encontraron semanas pendientes para actualizar para prestamo_id: " + prestamo_id);
            }
        } else {
            Log.d("SQLite", "Error al actualizar el status del préstamo para prestamo_id: " + prestamo_id);
        }

        // Cerrar la base de datos
        db.close();
    }

    private void getGrupoPoblacion(String poblacion_id)
    {

        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getGrupoPoblacion");
            data.put("poblacion_id", poblacion_id);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            JSONObject data = (JSONObject) response.get("data");
                            tlGrupo.getEditText().setText(data.get("grupo").toString());

                        } catch (JSONException e) {
                            throw new RuntimeException(e);
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(PrestamosCrearViewModel.class);
        // TODO: Use the ViewModel
    }

}